%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MATLAB code: Example 10.6 
% File: Bootstrap_SETAR.m
%
% THREE METHODS FOR OBTAINING ONE-SAMPLE PREDICTION INTERVALS OF SETAR MODELS
% Direct, but not very efficient and hence time-consuming, Matlab conversion 
% of RATS code "Bootstrap-SETAR.prg" of Jing Li

% INPUT:
% nb  = number of bootstrap replicates
% nmn = number of MC simulations 
% ob  = number of observations
% c1  = AR parameter first regime
% c   = AR parameter second regime
% tau = threshold parameter
%
% OUTPUT:
% tar  (CPI, a (1 * 8) vector)
% tarb1 tarb2 tarb3, 3 BS methods, for forecast horizons 1-8
% (in total a 3 * 8 matrix)
% Note: only 2 BS methods are computed
% 
% Reference:
% Li, J. (2011).
% Bootstrap prediction intervals for SETAR models.
%   International Journal of Forecasting, 27(2), 320-332.
%   DOI: 10.1016/j.ijforecast.2010.01.013
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% clear all;

warning('OFF') 

c1  = -0.4; c = 0.5; tau = 0.0;
ob  = 100;   
nb  = 100;   
nk  = 100;   
nmm = 500;  % CHANGE

ct1 = zeros(1,nmm);
ct2 = zeros(1,nmm);
ct3 = zeros(1,nmm);
ct4 = zeros(1,nmm);
ct5 = zeros(1,nmm);
ct6 = zeros(1,nmm);
ct7 = zeros(1,nmm);
ct8 = zeros(1,nmm);

y1b  = zeros(1,ob);
y1mb = zeros(1,ob);

for mm = 1:nmm   % start big LOOP MC simulations
disp(mm);
p    = 1;            % order AR

e = normrnd(0,1,ob+100,1);
yy(1) = 0;
for i=2:ob+100
    if yy(i-1)>tau
       yy(i) = c1*yy(i-1)+e(i);
    else
       yy(i) = c*yy(i-1)+e(i);
    end;
end;

y   = yy(1,101:ob+100)'; 
oy  = y;
low = 1+ round(ob*0.15);
up  = ob-round(ob*0.15);
bic = 100000;
yd  = lagmatrix(y,1); 
oyd = yd; 
oyd = sort(oyd);

for ind = low: up
  if yd(ind)>oyd(ind)
    indix = 1;
  else
    indix = 0;
  end;
  y1indix  = indix*lagmatrix(oy,1);
  y1mindix = (1-indix)*lagmatrix(oy,1);
  
  [~,~,re] = regress(oy,[y1indix y1mindix]);
  res  = re(2:ob,1);
  v1   = var(res)*ob/(ob-1);  
  if v1 < bic 
    bic = v1;
    tau = oyd(ind);
  else
  end;
end; 

%%%%%%%%%%  end search for tau = thre_bi

yd = lagmatrix(y,1);
oy = y;
    
for j=1:ob   
    if yd(j)>tau
       indi(j) = 1;
    else
       indi(j) = 0;
    end;
end;

for j=2:ob
   y1(j)  = indi(j)*oy(j-1);
   y1m(j) = (1-indi(j))*oy(j-1);
end;

[bb,bint,re] = regress(oy,[y1' y1m']);

b1  = bb(1);
b2  = bb(2);
res = re(2:ob,1);
v1  = var(res)*ob/(ob-1);   % seesq = sum of squares errors

%%%  FORECASTING SETAR(2;1,1) MODEL
  if y(ob)>tau   %% one-step
     yhat1 = b1*y(ob);
  else
     yhat1 = b2*y(ob);
  end;

  lt1 = yhat1-1.96*sqrt(v1);
  ut1 = yhat1+1.96*sqrt(v1);

  if yhat1>tau  %% two-step
     yhat2 = b1*yhat1;
  else
     yhat2 = b2*yhat1;
  end;

  if yhat1>tau
     v2 = b1^2*v1+v1;
  else
     v2 = b2^2*v1+v1;
  end;

  lt2 = yhat2-1.96*sqrt(v2);
  ut2 = yhat2+1.96*sqrt(v2);

  if yhat2>tau  %% three-step
     yhat3 = b1*yhat2;
  else
     yhat3 = b2*yhat2;
  end;

  if yhat2>tau
     v3 = b1^2*v2+v1;
  else
     v3 = b2^2*v2+v1;
  end;

  lt3 = yhat3-1.96*sqrt(v3);
  ut3 = yhat3+1.96*sqrt(v3);

  if yhat3>tau   %% four-step
     yhat4 = b1*yhat3;
  else
     yhat4 = b2*yhat3;
  end;
 
  if yhat3>tau
     v4 = b1^2*v3+v1;
  else
     v4 = b2^2*v3+v1;
  end;

  lt4 = yhat4-1.96*sqrt(v4);
  ut4 = yhat4+1.96*sqrt(v4);

  if yhat4>tau   %% five-step
     yhat5 = b1*yhat4;
  else
     yhat5 = b2*yhat4;
  end;
 
  if yhat4>tau
     v5 = b1^2*v4+v1;
  else
     v5 = b2^2*v4+v1;
  end;

  lt5 = yhat5-1.96*sqrt(v5);
  ut5 = yhat5+1.96*sqrt(v5);

  if yhat5>tau   %% six-step
     yhat6 = b1*yhat5;
  else
     yhat6 = b2*yhat5;
  end;
 
  if yhat5>tau
     v6 = b1^2*v5+v1;
  else
     v6 = b2^2*v5+v1;
  end;

  lt6 = yhat5-1.96*sqrt(v5);
  ut6 = yhat5+1.96*sqrt(v5);

  if yhat6>tau   %% seven-step
     yhat7 = b1*yhat6;
  else
     yhat7 = b2*yhat6;
  end;
 
  if yhat6>tau
     v7 = b1^2*v6+v1;
     else
     v7 = b2^2*v6+v1;
  end;

  lt7 = yhat6-1.96*sqrt(v6);
  ut7 = yhat6+1.96*sqrt(v6);

  if yhat7>tau   %% 8-step
     yhat8 = b1*yhat7;
  else
     yhat8 = b2*yhat7;
  end;
 
  if yhat7>tau
     v8 = b1^2*v7+v1;
  else
     v8 = b2^2*v7+v1;
  end;

  lt8 = yhat7-1.96*sqrt(v7);
  ut8 = yhat7+1.96*sqrt(v7);

%%%%%%%  end forecasting  %%%%%%%%%%%%%%%%%%

res(1)  = oy(1);

yhatb11 = zeros(1,nb);
yhatb12 = zeros(1,nb);
yhatb13 = zeros(1,nb);
yhatb14 = zeros(1,nb);
yhatb15 = zeros(1,nb);
yhatb16 = zeros(1,nb);
yhatb17 = zeros(1,nb);
yhatb18 = zeros(1,nb);

yhatb21 = zeros(1,nb);
yhatb22 = zeros(1,nb);
yhatb23 = zeros(1,nb);
yhatb24 = zeros(1,nb);
yhatb25 = zeros(1,nb);
yhatb26 = zeros(1,nb);
yhatb27 = zeros(1,nb);
yhatb28 = zeros(1,nb);

yhatb31 = zeros(1,nb);
yhatb32 = zeros(1,nb);
yhatb33 = zeros(1,nb);
yhatb34 = zeros(1,nb);
yhatb35 = zeros(1,nb);
yhatb36 = zeros(1,nb);
yhatb37 = zeros(1,nb);
yhatb38 = zeros(1,nb);
yb      = zeros(1,ob);

for bp = 1: nb   % start loop bp = 1:nb =999 number of bootstrap
%    bp
    
    reb = zeros(1,ob);
    for j = 1:ob   % ob =length(y)
        reb(j) = res(round(unifrnd(1,ob-1)));
    end;

    yb(1)=oy(1);   
    for j=2:ob
      if yb(j-1)>tau
         yb(j) = b1*yb(j-1)+reb(j);
      else
         yb(j) = b2*yb(j-1)+reb(j);
      end;
    end;

%%%%%  Method 1: TAR_Boot_pre_tau   %%%%%%%%%%%

   oyb     = yb;
   ydb     = lagmatrix(yb,1);
   oybhere = oyb;
   ydbhere = ydb;
  
   for j=2:ob   
     if ydb(j)>tau
       indib(j) = 1;
     else
       indib(j) = 0;
     end;
   end;
   
   for j=2:ob   
      y1b(j)  = indib(j)*oyb(j-1);  
      y1mb(j) = (1-indib(j))*oyb(j-1);
   end;

   beta = lscov([y1b' y1mb'], oyb');
   bb1  = beta(1);
   bb2  = beta(2);

   if y(ob)>tau   % one-step
      yhatb11(bp) = bb1*y(ob)+res(unidrnd(ob-1));
   else
      yhatb11(bp) = bb2*y(ob)+res(unidrnd(ob-1));
   end;

   if yhatb11(bp)>tau    % two-step
      yhatb12(bp) = bb1*yhatb11(bp)+res(unidrnd(ob-1));
    else
      yhatb12(bp) = bb2*yhatb11(bp)+res(unidrnd(ob-1));
   end;

   if yhatb12(bp)>tau    % 3-step
      yhatb13(bp) = bb1*yhatb12(bp)+res(unidrnd(ob-1));
   else
      yhatb13(bp) = bb2*yhatb12(bp)+res(unidrnd(ob-1));
   end;

   if yhatb13(bp)>tau   % 4-step
      yhatb14(bp) = bb1*yhatb13(bp)+res(unidrnd(ob-1));
   else
      yhatb14(bp) = bb2*yhatb13(bp)+res(unidrnd(ob-1));
   end;

   if yhatb14(bp)>tau   % 5-step
      yhatb15(bp) = bb1*yhatb14(bp)+res(unidrnd(ob-1));
   else
      yhatb15(bp) = bb2*yhatb14(bp)+res(unidrnd(ob-1));
   end;
     
   if yhatb15(bp)>tau   % 6-step
      yhatb16(bp) = bb1*yhatb15(bp)+res(unidrnd(ob-1));
   else
      yhatb16(bp) = bb2*yhatb15(bp)+res(unidrnd(ob-1));
   end;
     
   if yhatb16(bp)>tau   % 7-step
      yhatb17(bp) = bb1*yhatb16(bp)+res(unidrnd(ob-1));
   else
      yhatb17(bp) = bb2*yhatb16(bp)+res(unidrnd(ob-1));
   end;
     
   if yhatb17(bp)>tau   % 8-step
      yhatb18(bp) = bb1*yhatb17(bp)+res(unidrnd(ob-1));
   else
      yhatb18(bp) = bb2*yhatb17(bp)+res(unidrnd(ob-1));
   end;  

%%%%%%%%%% Method 2: TAR_Boot_est_tau   %%%%%%%%%%%%%%

   yb   = yb;
   ydb  = lagmatrix(yb,1);
   bicb = 100000;
   oydb = ydb; 
   oydb = sort(oydb);

   for ind = low: up
      if ydb(ind)>oydb(ind)
        indix = 1;
      else
        indix = 0;
      end;

      y1indix  = indix*lagmatrix(oyb,1);
      y1mindix = (1-indix)*lagmatrix(oyb,1);
      [~,~,re] = regress(oyb',[y1indix y1mindix]);
  
      res = re(2:ob,1);
      v1  = var(res)*ob/(ob-1);   % seesq = sum of squares errors
      if v1 < bicb 
        bicb   = v1;
        taubib = oydb(ind);
      else
      end;
   end; 

%%%%%%%%%%  end search for taubib = thre_bib

   ydb = lagmatrix(yb,1);  
   for j=1:ob  
      if ydb(j)>taubib
        indibib(j) = 1;
      else
        indibib(j) = 0;
      end;
   end;

   for j=2:ob
      y1(j)  = indibib(j)*oyb(j-1);
      y1m(j) = (1-indibib(j))*oyb(j-1);
   end;

   xmatrix = [y1' y1m'];
   mi      = inv(xmatrix'*xmatrix);
   bb      = mi*(xmatrix'*oyb');
   bbnew1  = bb(1);
   bbnew2  = bb(2);     

%%%%%%%  end estimation %%%%%%%%%%%%%

%%%%  Method 3: TAR_Boot_biascorrected_beta_with_pre_tau

   bb1b = zeros(1,200); 
   bb2b = zeros(1,200);

   for bpb = 1: 200
      rebb = zeros(1,ob);
      for j = 1: ob
         rebb(j) = res(round(unifrnd(1, ob-1)));
      end; 
      ybb(1) = oy(1);
      for j = 2:ob
         if ybb(j-1)>tau
           ybb(j) = b1*ybb(j-1)+rebb(j);
         else
           ybb(j) = b2*ybb(j-1)+rebb(j);
         end;
      end;
 
      oyb = ybb;
      ydb = lagmatrix(ybb,1);

      for j = 2:ob
         if ydb(j)>tau
           indib(j) = 1;
         else
           indib(j) = 0;
         end;
      end;
    
      for j = 2:ob
         y1b(j)  = indib(j)*oyb(j-1);
         y1mb(j) = (1-indib(j))*oyb(j-1);
      end;

      beta      = lscov([y1mb' y1b'], oyb');
      bb1b(bpb) = beta(1);
      bb2b(bpb) = beta(2);
   end;   % end loop bpb = 1:200

   b1cor = 2*b1-sum(bb1b)/200;
   b2cor = 2*b2-sum(bb2b)/200;

   ybc(1) = oy(1); 
   for j = 2:ob
      if ybc(j-1)>tau
        ybc(j) = b1cor*ybc(j-1)+reb(j);
      else
        ybc(j) = b2cor*ybc(j-1)+reb(j);
      end;
   end;

   oyb = ybc;
   ydb = lagmatrix(ybc,1);

   for j = 2:ob
      if ydb(j)>tau
        y1b(j)  = indib(j)*oyb(j-1); 
      else
        y1mb(j) = (1-indib(j))*oyb(j-1);
      end;
    end;

    beta = lscov([y1b' y1mb'], oyb');
    bb1  = beta(1);
    bb2  = beta(2);

%%%  end estimation TAR_Boot_biascorrected_beta_with_pre_tau
%%%  Start forecasting   *****

   if y(ob)>tau   % one-step
      yhatb31(bp) = bb1*y(ob)+res(unidrnd(ob-1));
   else
      yhatb31(bp) = bb2*y(ob)+res(unidrnd(ob-1));
   end;

   if yhatb31(bp)>tau    % two-step
      yhatb32(bp) = bb1*yhatb31(bp)+res(unidrnd(ob-1));
   else
      yhatb32(bp) = bb2*yhatb31(bp)+res(unidrnd(ob-1));
   end;

   if yhatb32(bp)>tau    % 3-step
      yhatb33(bp) = bb1*yhatb32(bp)+res(unidrnd(ob-1));
   else
      yhatb33(bp) = bb2*yhatb32(bp)+res(unidrnd(ob-1));
   end;

   if yhatb33(bp)>tau   % 4-step
      yhatb34(bp) = bb1*yhatb33(bp)+res(unidrnd(ob-1));
   else
      yhatb34(bp) = bb2*yhatb33(bp)+res(unidrnd(ob-1));
   end;

   if yhatb34(bp)>tau   % 5-step
      yhatb35(bp) = bb1*yhatb34(bp)+res(unidrnd(ob-1));
   else
      yhatb35(bp) = bb2*yhatb34(bp)+res(unidrnd(ob-1));
   end;
     
   if yhatb35(bp)>tau   % 6-step
      yhatb36(bp) = bb1*yhatb35(bp)+res(unidrnd(ob-1));
   else
      yhatb36(bp) = bb2*yhatb35(bp)+res(unidrnd(ob-1));
   end;
     
   if yhatb36(bp)>tau   % 7-step
      yhatb37(bp) = bb1*yhatb36(bp)+res(unidrnd(ob-1));
   else
      yhatb37(bp) = bb2*yhatb36(bp)+res(unidrnd(ob-1));
   end;
     
   if yhatb37(bp)>tau   % 8-step
      yhatb38(bp) = bb1*yhatb37(bp)+res(unidrnd(ob-1));
   else
      yhatb38(bp) = bb2*yhatb37(bp)+res(unidrnd(ob-1));
   end;  

end;  %%%%%%%% end loop bp = 1:nb = 999 no. of bootstrap repl.

yhatb11 = sort(yhatb11); 
yhatb12 = sort(yhatb12); 
yhatb13 = sort(yhatb13);    
yhatb14 = sort(yhatb14); 
yhatb15 = sort(yhatb15); 
yhatb16 = sort(yhatb16); 
yhatb17 = sort(yhatb17);    
yhatb18 = sort(yhatb18); 

ltb11   = yhatb11(ceil(0.025*nb));
utb11   = yhatb11(ceil(0.975*nb));
ltb12   = yhatb12(ceil(0.025*nb));
utb12   = yhatb12(ceil(0.975*nb));
ltb13   = yhatb13(ceil(0.025*nb));
utb13   = yhatb13(ceil(0.975*nb));
ltb14   = yhatb14(ceil(0.025*nb));
utb14   = yhatb14(ceil(0.975*nb));

ltb15   = yhatb15(ceil(0.025*nb));
utb15   = yhatb15(ceil(0.975*nb));
ltb16   = yhatb16(ceil(0.025*nb));
utb16   = yhatb16(ceil(0.975*nb));
ltb17   = yhatb17(ceil(0.025*nb));
utb17   = yhatb17(ceil(0.975*nb));
ltb18   = yhatb18(ceil(0.025*nb));
utb18   = yhatb18(ceil(0.975*nb));

yhatb21 = sort(yhatb21); 
yhatb22 = sort(yhatb22); 
yhatb23 = sort(yhatb23);    
yhatb24 = sort(yhatb24); 
yhatb25 = sort(yhatb25); 
yhatb26 = sort(yhatb26); 
yhatb27 = sort(yhatb27);    
yhatb28 = sort(yhatb28); 

ltb21   = yhatb21(ceil(0.025*nb));
utb21   = yhatb21(ceil(0.975*nb));
ltb22   = yhatb22(ceil(0.025*nb));
utb22   = yhatb22(ceil(0.975*nb));
ltb23   = yhatb23(ceil(0.025*nb));
utb23   = yhatb23(ceil(0.975*nb));
ltb24   = yhatb24(ceil(0.025*nb));
utb24   = yhatb24(ceil(0.975*nb));

ltb25   = yhatb25(ceil(0.025*nb));
utb25   = yhatb25(ceil(0.975*nb));
ltb26   = yhatb26(ceil(0.025*nb));
utb26   = yhatb26(ceil(0.975*nb));
ltb27   = yhatb27(ceil(0.025*nb));
utb27   = yhatb27(ceil(0.975*nb));
ltb28   = yhatb28(ceil(0.025*nb));
utb28   = yhatb28(ceil(0.975*nb));

yhatb31 = sort(yhatb31); 
yhatb32 = sort(yhatb32); 
yhatb33 = sort(yhatb33);    
yhatb34 = sort(yhatb34); 
yhatb35 = sort(yhatb35); 
yhatb36 = sort(yhatb36); 
yhatb37 = sort(yhatb37);    
yhatb38 = sort(yhatb38); 
 
ltb31   = yhatb31(ceil(0.025*nb));
utb31   = yhatb31(ceil(0.975*nb));
ltb32   = yhatb32(ceil(0.025*nb));
utb32   = yhatb32(ceil(0.975*nb));
ltb33   = yhatb33(ceil(0.025*nb));
utb33   = yhatb33(ceil(0.975*nb));
ltb34   = yhatb34(ceil(0.025*nb));
utb34   = yhatb34(ceil(0.975*nb));

ltb35   = yhatb35(ceil(0.025*nb));
utb35   = yhatb35(ceil(0.975*nb));
ltb36   = yhatb36(ceil(0.025*nb));
utb36   = yhatb36(ceil(0.975*nb));
ltb37   = yhatb37(ceil(0.025*nb));
utb37   = yhatb37(ceil(0.975*nb));
ltb38   = yhatb38(ceil(0.025*nb));
utb38   = yhatb38(ceil(0.975*nb));


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%  end part for ONE series case
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Average coverage
covt1=0.0; covt2=0.0; covt3=0.0; covt4=0.0;
covt5=0.0; covt6=0.0; covt7=0.0; covt8=0.0;

covtb11=0.0; covtb12=0.0; covtb13=0.0; covtb14=0.0;
covtb15=0.0; covtb16=0.0; covtb17=0.0; covtb18=0.0;

covtb21=0.0; covtb22=0.0; covtb23=0.0; covtb24=0.0;
covtb25=0.0; covtb26=0.0; covtb27=0.0; covtb28=0.0;

covtb31=0.0; covtb32=0.0; covtb33=0.0; covtb34=0.0;
covtb35=0.0; covtb36=0.0; covtb37=0.0; covtb38=0.0;

for  j = 1: nk   % nk = 100 = m (in paper)
  e1 = e(randi(ob)); e2 = e(randi(ob)); e3 = e(randi(ob)); e4 = e(randi(ob));
  e5 = e(randi(ob)); e6 = e(randi(ob)); e7 = e(randi(ob)); e8 = e(randi(ob));

  if (y(ob)>tau)
     yf1 = c1*y(ob)+e1;
  else
     yf1 = c*y(ob)+e1;
  end;
  if (yf1>tau)
     yf2 = c1*yf1+e2;
  else
     yf2 = c*yf1+e2;
  end;
  if (yf2>tau)
     yf3 = c1*yf2+e3;
  else
     yf3 = c*yf2+e3;
  end;
  if (yf3>tau)
     yf4 = c1*yf3+e4;
  else
     yf4 = c*yf3+e4;
  end;
  if (yf4>tau)
     yf5 = c1*yf4+e5;
  else
     yf5 =c*yf4+e5;
  end;
  if (yf5>tau)
     yf6 = c1*yf5+e6;
  else
     yf6 =c*yf5+e6;
  end;
  if (yf6>tau)
     yf7 = c1*yf6+e7;
  else
     yf7 = c*yf6+e7;
  end;
  if (yf7>tau)
    yf8 = c1*yf7+e8;
  else
    yf8 = c*yf7+e8;
  end;

  covt1   = covt1 + (yf1>lt1).*(yf1<ut1);covt2 = covt2 + (yf2>lt2).*(yf2<ut2);
  covt3   = covt3 + (yf3>lt3).*(yf3<ut3);covt4 = covt4 + (yf4>lt4).*(yf4<ut4);
  covt5   = covt5 + (yf5>lt5).*(yf5<ut5);covt6 = covt6 + (yf6>lt6).*(yf6<ut6);
  covt7   = covt7 + (yf7>lt7).*(yf7<ut7);covt8 = covt8 + (yf8>lt8).*(yf8<ut8);

  covtb11 = covtb11 + (yf1>ltb11).*(yf1<utb11);covtb12 = covtb12 + (yf2>ltb12).*(yf2<utb12);
  covtb13 = covtb13 + (yf3>ltb13).*(yf3<utb13);covtb14 = covtb14 + (yf4>ltb14).*(yf4<utb14);
  covtb15 = covtb15 + (yf5>ltb15).*(yf5<utb15);covtb16 = covtb16 + (yf6>ltb16).*(yf6<utb16);
  covtb17 = covtb17 + (yf7>ltb17).*(yf7<utb17);covtb18 = covtb18 + (yf8>ltb18).*(yf8<utb18);

  covtb21 = covtb21 + (yf1>ltb21).*(yf1<utb21);covtb22 = covtb22 + (yf2>ltb22).*(yf2<utb22);
  covtb23 = covtb23 + (yf3>ltb23).*(yf3<utb23);covtb24 = covtb24 + (yf4>ltb24).*(yf4<utb24);
  covtb25 = covtb25 + (yf5>ltb25).*(yf5<utb25);covtb26 = covtb26 + (yf6>ltb26).*(yf6<utb26);
  covtb27 = covtb27 + (yf7>ltb27).*(yf7<utb27);covtb28 = covtb28 + (yf8>ltb28).*(yf8<utb28);

  covtb31 = covtb31 + (yf1>ltb31).*(yf1<utb31);covtb32 = covtb32 + (yf2>ltb32).*(yf2<utb32);
  covtb33 = covtb33 + (yf3>ltb33).*(yf3<utb33);covtb34 = covtb34 + (yf4>ltb34).*(yf4<utb34);
  covtb35 = covtb35 + (yf5>ltb35).*(yf5<utb35);covtb36 = covtb36 + (yf6>ltb36).*(yf6<utb36);
  covtb37 = covtb37 + (yf7>ltb37).*(yf7<utb37);covtb38 = covtb38 + (yf8>ltb38).*(yf8<utb38);

end   % end j =1: nk = m = 100

%%  CPI results
ct1(mm)  = covt1/nk; ct2(mm) = covt2/nk; ct3(mm) = covt3/nk; ct4(mm) = covt4/nk;
ct5(mm)  = covt5/nk; ct6(mm) = covt6/nk; ct7(mm) = covt7/nk; ct8(mm) = covt8/nk;

%% Bootstrap results
cb11(mm) = covtb11/nk; cb12(mm) = covtb12/nk; cb13(mm) = covtb13/nk; cb14(mm) = covtb14/nk;
cb15(mm) = covtb15/nk; cb16(mm) = covtb16/nk; cb17(mm) = covtb17/nk; cb18(mm) = covtb18/nk;

cb21(mm) = covtb21/nk; cb22(mm) = covtb22/nk; cb23(mm) = covtb23/nk; cb24(mm) = covtb24/nk;
cb25(mm) = covtb25/nk; cb26(mm) = covtb26/nk; cb27(mm) = covtb27/nk; cb28(mm) = covtb28/nk;

cb31(mm) = covtb31/nk; cb32(mm) = covtb32/nk; cb33(mm) = covtb33/nk; cb34(mm) = covtb34/nk;
cb35(mm) = covtb35/nk; cb36(mm) = covtb36/nk; cb37(mm) = covtb37/nk; cb38(mm) = covtb38/nk;

end;   % end BIG LOOP mm = 1: nmm nmm= 500 = MC number of Monte Carlo repl.

% CPI results
tar(1) = sum(ct1)/nmm; tar(2) = sum(ct2)/nmm; tar(3) = sum(ct3)/nmm; tar(4) = sum(ct4)/nmm;
tar(5) = sum(ct5)/nmm; tar(6) = sum(ct6)/nmm; tar(7) = sum(ct7)/nmm; tar(8) = sum(ct8)/nmm;

% Bootstrap results
tarb1(1) = sum(cb11)/nmm; tarb1(2) = sum(cb12)/nmm; tarb1(3) = sum(cb13)/nmm; tarb1(4) = sum(cb14)/nmm;
tarb1(5) = sum(cb15)/nmm; tarb1(6) = sum(cb16)/nmm; tarb1(7) = sum(cb17)/nmm; tarb1(8) = sum(cb18)/nmm;

tarb2(1) = sum(cb21)/nmm; tarb2(2) = sum(cb22)/nmm; tarb2(3) = sum(cb23)/nmm; tarb2(4) = sum(cb24)/nmm;
tarb2(5) = sum(cb25)/nmm; tarb2(6) = sum(cb26)/nmm; tarb2(7) = sum(cb27)/nmm; tarb2(8) = sum(cb28)/nmm;

tarb3(1) = sum(cb31)/nmm; tarb3(2) = sum(cb32)/nmm; tarb3(3) = sum(cb33)/nmm; tarb3(4) = sum(cb34)/nmm;
tarb3(5) = sum(cb35)/nmm; tarb3(6) = sum(cb36)/nmm; tarb3(7) = sum(cb37)/nmm; tarb3(8) = sum(cb38)/nmm;

